<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - CuanBijak</title>
    <link href="../bootstrap-5.3.3-dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <style>
        body {
            padding-top: 60px; /* Sesuaikan dengan tinggi navbar */
            background-color: #f8f9fa; /* Warna latar belakang yang lebih lembut */
            
        }
        .navbar-nav .nav-link:hover {
            color:rgb(179, 86, 90) !important;
        }
        /* Navbar Styling */
        .navbar-custom {
            background-color:rgb(56, 56, 56) !important; /* Warna abu-abu gelap */
            box-shadow: 0px 4px 6px rgba(150, 8, 8, 0.1);
            padding: 12px 0;
        }
        .transaction-item:hover {
            background-color: rgba(150, 8, 8, 0.1);
            transition: background-color 0.3s ease;
            cursor: pointer;
        }
        
        .navbar-nav .nav-link {
            color: #fff !important;
            font-weight: 500;
            transition: color 0.3s;
        }
    </style>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">   
</head>

<body>
    <nav class="navbar navbar-expand-lg navbar-dark navbar-custom fixed-top">
        <div class="container">            
            <a class="navbar-brand" href="#">
                <img src="../image/cuan.png" alt="CuanBijak Logo" width="50">
            </a>
            <a class="navbar-brand" href="#">CuanBijak</a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item"><a class="nav-link" href="dashboard.php">Beranda</a></li>
                    <li class="nav-item"><a class="nav-link" href="transaction.php">Transaksi</a></li>
                    <li class="nav-item"><a class="nav-link" href="history.php">Riwayat</a></li>
                    
                    <!-- Tambahkan Dropdown Akun -->
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            Akun
                        </a>
                        <ul class="dropdown-menu" aria-labelledby="navbarDropdown">
                            <li><a class="dropdown-item" href="profile.php">Profil</a></li>
                            <li><a class="dropdown-item" href="#" onclick="logout()">Logout</a></li>
                        </ul>
                    </li>
                </ul>
        </div>
    </nav>
    <div class="container my-5">
        <!-- Tambahan Logo -->
        <div class="text-center mb-3">
            <img src="../image/cuan.png" alt="CuanBijak Logo" width="150">
        </div>
        <h2 class="text-center">Ringkasan Keuangan</h2>

        <!-- Saldo -->
        <div class="container mt-5 pt-5">
            <div class="row">
                <div class="col-md-4">
                    <div class="card p-3 text-center">
                        <h5><i class="fas fa-wallet"></i> Saldo</h5>
                        <p class="display-6" id="saldoAmount">Loading...</p>
                    </div>
                </div>
        <!-- Grafik -->
        <div class="col-md-8">
            <div class="card p-3">
                <h5><i class="fas fa-chart-line"></i> Grafik Pengeluaran & Pemasukan</h5>
                <canvas id="transactionChart"></canvas>
            </div>
        </div>
    </div>        
        <!-- Riwayat -->
        <div class="row my-4">
            <div class="col-md-12">
                <h5><i class="fas fa-history"></i> Riwayat Transaksi</h5>
                <div class="card p-3" id="transactionHistory"></div>
            </div>
        </div>
    </div>
               
    <script src="../bootstrap-5.3.3-dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>
    <script>
        // Cek session
        function checkSession() {
            const formData = new FormData();
            formData.append('session_token', localStorage.getItem('session_token'));

            axios.post('../api/session.php', formData)
                .then(response => {
                    if (response.data.status !== 'success') {
                        window.location.href = 'login.php';
                    }
                })
                .catch(error => {
                    console.error('Error checking session:', error);
                });
        }

        // Logout
        function logout() {
            const formData = new FormData();
            formData.append('session_token', localStorage.getItem('session_token'));

            axios.post('../api/logout.php', formData)
                .then(response => {
                    if (response.data.status == 'success') {
                        localStorage.removeItem('session_token');
                        window.location.href = 'login.php';
                    } else {
                        alert('Logout failed. Please try again.');
                    }
                })
                .catch(error => {
                    console.error('Error during logout:', error);
                });
        }

        // Fungsi animasi counting saldo
function animateBalance(finalBalance) {
    let saldoElement = document.getElementById('saldoAmount');
    let currentBalance = 0;
    let increment = Math.ceil(finalBalance / 100); // Menentukan kenaikan angka tiap frame
    let duration = 1000; // Durasi animasi dalam milidetik
    let startTime = null;

    function updateBalance(timestamp) {
        if (!startTime) startTime = timestamp;
        let progress = timestamp - startTime;

        let newBalance = Math.min(currentBalance + increment, finalBalance);
        saldoElement.textContent = `Rp ${newBalance.toLocaleString()}`;

        if (newBalance < finalBalance) {
            currentBalance = newBalance;
            requestAnimationFrame(updateBalance);
        } else {
            saldoElement.textContent = `Rp ${finalBalance.toLocaleString()}`; // Pastikan angka final muncul
        }
    }

    requestAnimationFrame(updateBalance);
}

// Load saldo dengan animasi
function loadBalance() {
    axios.get(`../api/transaction/get.php?session_token=${localStorage.getItem('session_token')}`)
        .then(response => {
            if (response.data.status === 'success') {
                const transactions = response.data.data;
                let totalBalance = 0;
                transactions.forEach(transaction => {
                    if (transaction.statusTransaksi == 1) {
                        totalBalance += Number(transaction.amount);
                    } else {
                        totalBalance -= transaction.amount;
                    }
                });

                // Menjalankan animasi counting
                animateBalance(totalBalance);

                // Mengubah warna saldo sesuai kondisi
                const saldoElement = document.getElementById('saldoAmount');
                saldoElement.style.color = totalBalance < 0 ? 'red' : 'green';
            } else {
                alert('Failed to fetch transactions data.');
            }
        })
        .catch(error => {
            console.error('Error loading balance:', error);
        });
}

        
        // Fungsi untuk menghitung dan menampilkan tanggal dalam format yang lebih deskriptif
        function formatTransactionDate(date) {
            const today = new Date();
            const transactionDate = new Date(date);
            const diffTime = today - transactionDate;
            const diffDays = Math.floor(diffTime / (1000 * 3600 * 24)); // Menghitung selisih hari
            const diffWeeks = Math.floor(diffDays / 7); // Menghitung minggu
            const diffMonths = Math.floor(diffDays / 30); // Menghitung bulan

            // Format tanggal berdasarkan selisih waktu
            if (diffDays === 0) {
                return 'Today'; // Jika tanggalnya hari ini
            } else if (diffDays === 1) {
                return 'Yesterday'; // Jika tanggalnya kemarin
            } else if (diffDays < 7) {
                return `${diffDays} days ago`; // Jika beberapa hari lalu
            } else if (diffWeeks < 4) {
                return `${diffWeeks} week${diffWeeks > 1 ? 's' : ''} ago`; // Jika beberapa minggu lalu
            } else if (diffMonths < 12) {
                return `${diffMonths} month${diffMonths > 1 ? 's' : ''} ago`; // Jika beberapa bulan lalu
            } else {
                const year = transactionDate.getFullYear();
                const month = transactionDate.getMonth() + 1; // Januari = 0
                const day = transactionDate.getDate();
                return `${month}/${day}/${year}`; // Jika lebih dari setahun, tampilkan dalam format MM/DD/YYYY
            }
        }

        // Menampilkan riwayat transaksi
        function loadTransactionHistory() {
            axios.get(`../api/transaction/get.php?session_token=${localStorage.getItem('session_token')}`)
                .then(response => {
                    if (response.data.status === 'success') {
                        const transactions = response.data.data.slice(0, 5); // Ambil 5 transaksi terakhir
                        const historyContainer = document.getElementById('transactionHistory');
                        historyContainer.innerHTML = '';

                        transactions.forEach(transaction => {
                            const transactionItem = document.createElement('div');
                            transactionItem.classList.add('d-flex', 'justify-content-between', 'align-items-center', 'mb-3', 'transaction-item'); // Menambahkan class transaction-item
                            const formattedDate = formatTransactionDate(transaction.date);
                            transactionItem.innerHTML = `
                                <div>
                                    <strong>${transaction.statusTransaksi == 1 ? '<i class="fas fa-arrow-down text-success"></i> Pemasukan' : '<i class="fas fa-arrow-up text-danger"></i> Pengeluaran'}</strong>
                                    - ${transaction.category}
                                    <div class="text-muted">${formattedDate}</div>
                                </div>
                                <div class="${transaction.statusTransaksi == 1 ? 'text-success' : 'text-danger'}">
                                    Rp ${transaction.amount.toLocaleString()}
                                </div>
                        `;
                        historyContainer.appendChild(transactionItem);
                        });

                    } else {
                        alert('Gagal memuat histori transaksi. ' + response.data.message);
                    }
                })
                .catch(error => {
                    console.error('Terjadi masalah saat memuat histori transaksi:', error);
                });
        }

        // Menampilkan grafik pengeluaran & pemasukan
        function loadTransactionChart() {
            axios.get(`../api/transaction/get.php?session_token=${localStorage.getItem('session_token')}`)
                .then(response => {
                    if (response.data.status === 'success') {
                        const transactions = response.data.data;
                        const labels = [];
                        const dataPemasukan = [];
                        const dataPengeluaran = [];

                        transactions.forEach(transaction => {
                            const transactionDate = new Date(transaction.date);
                            const dateString = transactionDate.toLocaleDateString();
                            if (!labels.includes(dateString)) {
                                labels.push(dateString);
                                dataPemasukan.push(0);
                                dataPengeluaran.push(0);
                            }

                            const index = labels.indexOf(dateString);
                            console.log(transaction.statusTransaksi)
                            if (transaction.statusTransaksi == 1) {
                                dataPemasukan[index] += transaction.amount;
                            } else {
                                console.log("keluar");
                                dataPengeluaran[index] += transaction.amount;
                            }
                        });

                        const ctx = document.getElementById('transactionChart').getContext('2d');
                        new Chart(ctx, {
                            type: 'line', // Mengubah tipe grafik menjadi line
                            data: {
                                labels: labels,
                                datasets: [
                                    {
                                        label: 'Pemasukan',
                                        data: dataPemasukan,
                                        borderColor: 'rgba(40, 167, 69, 1)', // Hijau
                                        fill: false,
                                    },
                                    {
                                        label: 'Pengeluaran',
                                        data: dataPengeluaran,
                                        borderColor: 'rgba(220, 53, 69, 1)', // Merah
                                        fill: false,
                                    }
                                ]
                            },
                            options: {
                                responsive: true,
                                plugins: {
                                    title: {
                                        display: true,
                                        text: 'Pengeluaran & Pemasukan'
                                    },
                                    tooltip: {
                                        mode: 'index',
                                        intersect: false,
                                    }
                                },
                                scales: {
                                    y: {
                                        beginAtZero: true,
                                    }
                                }
                            }
                        });
                    } else {
                        alert('Gagal memuat histori transaksi. ' + response.data.message);
                    }
                })
                .catch(error => {
                    console.error('Terjadi masalah saat memuat histori transaksi:', error);
                });
        }

        // Menjalankan semua fungsi
        checkSession();
        loadBalance();
        loadTransactionHistory();
        loadTransactionChart();
    </script>
</body>
<?php include 'footer.php'; ?>


</html>
