<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>History Transaksi - CuanBijak</title>
    <link href="../bootstrap-5.3.3-dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-datepicker/dist/css/bootstrap-datepicker.min.css" rel="stylesheet">
    <style>
        body            
        .navbar-custom {
            background-color:rgb(56, 56, 56) !important; /* Warna abu-abu gelap */
            box-shadow: 0px 4px 6px rgba(150, 8, 8, 0.1);
            padding: 12px 0;
        }
        .transaction-item:hover {
            background-color: rgba(150, 8, 8, 0.1);
            transition: background-color 0.3s ease;
            cursor: pointer;
        }

        body{
            padding-top: 60px; /* Sesuaikan dengan tinggi navbar */
            background-color: #f8f9fa; /* Warna latar belakang yang lebih lembut */
        }     
        
        .navbar-nav .nav-link {
            color: #fff !important;
            font-weight: 500;
            transition: color 0.3s;
        }

        .navbar-nav .nav-link:hover {
            color:rgb(179, 86, 90) !important;
        }

        /* Tombol */
        .btn-primary {
            background-color: #ff9800 !important;
            border: none;
        }

        .btn-primary:hover {
            background-color: #e68900 !important;
        }

        .btn-warning {
            background-color: #ffc107 !important;
            border: none;
        }

        .btn-warning:hover {
            background-color: #e0a800 !important;
        }

        .btn-danger {
            background-color:rgb(226, 74, 74) !important;
            border: none;
        }

        .btn-danger:hover {
            background-color:rgb(226, 74, 74) !important;
        }

        /* List Transaksi */
        .transaction-item {
            background-color: white;
            border-radius: 10px;
            padding: 15px;
            box-shadow: 0px 2px 4px rgba(0, 0, 0, 0.1);
            transition: all 0.3s ease;
        }

        .transaction-item:hover {
            background-color: #f1f1f1;
            transform: scale(1.02);
        }

        /* Pagination */
        #pagination button {
            margin: 0 5px;
        }
        .wrapper {
            display: grid;
            grid-template-rows: auto 1fr auto;
            min-height: 100vh;
        }
    </style>
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark navbar-custom fixed-top">
        <div class="container">
            <a class="navbar-brand" href="#">
                <img src="../image/cuan.png" alt="CuanBijak Logo" width="50">
            </a>
            <a class="navbar-brand" href="#">CuanBijak</a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item"><a class="nav-link" href="dashboard.php">Beranda</a></li>
                    <li class="nav-item"><a class="nav-link" href="transaction.php">Transaksi</a></li>
                    <li class="nav-item"><a class="nav-link" href="history.php">Riwayat</a></li>
                    
                    <!-- Tambahkan Dropdown Akun -->
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            Akun
                        </a>
                        <ul class="dropdown-menu" aria-labelledby="navbarDropdown">
                            <li><a class="dropdown-item" href="profile.php">Profil</a></li>
                            <li><a class="dropdown-item" href="#" onclick="logout()">Logout</a></li>
                        </ul>
                    </li>
                </ul>
        </div>
    </nav>
    <div class="container my-5">

    <!-- History Transaction Section -->
    <div class="wrapper">
        <h2 class="text-center">History Transaksi</h2>
        <div id="transaction-history" class="list-group mt-4">
        </div>
        <div id="pagination" class="d-flex justify-content-center mt-4">
            <!-- Tombol navigasi halaman akan dimasukkan secara dinamis -->
        </div>
    </div>

    <!-- Edit Transaction Modal -->
    <div class="modal fade" id="editTransactionModal" tabindex="-1" aria-labelledby="editTransactionModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="editTransactionModalLabel">Edit Transaction</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form id="editTransactionForm">
                        <div class="mb-3">
                            <label for="transactionDate" class="form-label">Tanggal Transaksi</label>
                            <input type="text" class="form-control" id="transactionDate" placeholder="Pilih Tanggal" required>
                        </div>
                        <div class="mb-3">
                            <label for="editAmount" class="form-label">Jumlah</label>
                            <input type="number" class="form-control" id="editAmount" required>
                        </div>
                        <div class="mb-3">
                            <label for="editCategory" class="form-label">Kategori</label>
                            <select class="form-select" id="editCategory" required>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label for="editStatus" class="form-label">Status Transaksi</label>
                            <select class="form-select" id="editStatus" required>
                                <option value="1">Pemasukan</option>
                                <option value="0">Pengeluaran</option>
                            </select>
                        </div>
                        <button type="submit" class="btn btn-primary">Save Changes</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Delete Confirmation Modal -->
    <div class="modal fade" id="deleteConfirmationModal" tabindex="-1" aria-labelledby="deleteConfirmationModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteConfirmationModalLabel">Konfirmasi Hapus</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>Apakah Anda yakin ingin menghapus transaksi ini?</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="button" id="confirmDeleteButton" class="btn btn-danger">Hapus</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Script untuk Axios dan Bootstrap -->
    <script src="../bootstrap-5.3.3-dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap-datepicker@1.9.0/dist/js/bootstrap-datepicker.min.js"></script>
    <script>
        let currentTransactionId = null;
        let currentPage = 1;
        let transactionsData = [];
        let totalPages = 1;

        function logout() {
            const sessionToken = localStorage.getItem('session_token');

            const formData = new FormData();
            formData.append('session_token', sessionToken);

            axios.post('../api/logout.php', formData)
                .then(response => {
                    if (response.data.status == 'success') {
                        localStorage.removeItem('session_token');
                        window.location.href = 'login.php'
                    } else {
                        alert('logout failed. Please try again.' + response.data.message)
                    }
                })
                .catch(error => {
                    console.error('Error during logout:', error)
                });
        }

        function checkSession() {
            const formData = new FormData();
            formData.append('session_token', localStorage.getItem('session_token'));

            axios.post('../api/session.php', formData)
                .then(response => {
                    console.log(response);
                    if (response.data.status !== 'success') {
                        window.location.href = 'login.php'
                    }
                })
                .catch(error => {
                    console.error('Error checking session:', error);
                });
        }

        checkSession();

        function loadTransactionHistory() {
            axios.get(`../api/transaction/get.php?session_token=${localStorage.getItem('session_token')}`)
                .then(response => {
                    if (response.data.status === 'success') {
                        transactionsData = response.data.data; // Ambil semua transaksi
                        const historyContainer = document.getElementById('transaction-history');
                        historyContainer.innerHTML = ''; 

                        const startIndex = (currentPage - 1) * 10; // Index transaksi yang akan ditampilkan
                        const endIndex = Math.min(startIndex + 10, transactionsData.length); // Menentukan batas akhir data yang ditampilkan

                        // Tampilkan transaksi untuk halaman saat ini
                        for (let i = startIndex; i < endIndex; i++) {
                            const transaction = transactionsData[i];
                            const transactionItem = document.createElement('div');
                            transactionItem.classList.add('list-group-item', 'd-flex', 'justify-content-between', 'align-items-start', 'mb-3');
                            
                            // Format date (Today, Yesterday, etc.)
                            const transactionDate = new Date(transaction.date);
                            const today = new Date();
                            const diffTime = today - transactionDate;
                            const daysAgo = Math.floor(diffTime / (1000 * 3600 * 24));

                            let dateLabel = '';
                            if (daysAgo === 0) {
                                dateLabel = 'Today';
                            } else if (daysAgo === 1) {
                                dateLabel = 'Yesterday';
                            } else {
                                dateLabel = transactionDate.toLocaleDateString();
                            }

                            const currencyFormatter = new Intl.NumberFormat('id-ID', {
                                style: 'currency',
                                currency: 'IDR',
                                minimumFractionDigits: 0
                            });

                            // Formating text uang
                            const amountClass = transaction.statusTransaksi == 1 ? 'text-success' : 'text-danger';
                            const formattedAmount = currencyFormatter.format(transaction.amount);

                            // Desain hitory transaksi per baris
                            transactionItem.innerHTML = `
                                <div class="d-flex flex-column">
                                    <div><strong>${transaction.statusTransaksi == 1 ? 'Pemasukan' : 'Pengeluaran'}</strong> - ${transaction.category}</div>
                                    <div class="${amountClass}">${formattedAmount}</div>
                                </div>
                                <div>
                                    <div>
                                        <div>${dateLabel}</div>
                                        <button class="btn btn-warning btn-sm me-1" onclick="editTransaction(${transaction.id})">Edit</button>
                                        <button class="btn btn-danger btn-sm" onclick="confirmDeleteTransaction(${transaction.id})">Delete</button>
                                    </div>
                                </div>
                            `;

                            historyContainer.appendChild(transactionItem);
                        }

                        // Update jumlah total halaman
                        totalPages = Math.ceil(transactionsData.length / 10);
                        renderPagination(); // Menampilkan tombol navigasi
                    } else {
                        alert('Fetching history data failed. Please try again.' + response.data.message);
                    }
                })
                .catch(error => {
                    console.error('Error fetching transaction history:', error);
                });
        }

        function renderPagination() {
            const paginationContainer = document.getElementById('pagination');
            paginationContainer.innerHTML = '';

            if (totalPages > 1) {
                const prevButton = document.createElement('button');
                prevButton.textContent = 'Previous';
                prevButton.classList.add('btn', 'btn-secondary', 'btn-sm');
                prevButton.disabled = currentPage === 1;
                prevButton.onclick = function () {
                    if (currentPage > 1) {
                        currentPage--;
                        loadTransactionHistory();
                    }
                };
                paginationContainer.appendChild(prevButton);

                const pageInfo = document.createElement('span');
                pageInfo.textContent = `Page ${currentPage} of ${totalPages}`;
                pageInfo.classList.add('mx-3');
                paginationContainer.appendChild(pageInfo);

                const nextButton = document.createElement('button');
                nextButton.textContent = 'Next';
                nextButton.classList.add('btn', 'btn-secondary', 'btn-sm');
                nextButton.disabled = currentPage === totalPages;
                nextButton.onclick = function () {
                    if (currentPage < totalPages) {
                        currentPage++;
                        loadTransactionHistory();
                    }
                };
                paginationContainer.appendChild(nextButton);
            }
        }

        function editTransaction(id) {
            currentTransactionId = id;
            axios.get(`../api/transaction/get.php?session_token=${localStorage.getItem('session_token')}&id=${currentTransactionId}`)
                .then(response => {
                    console.log(response.data);
                    if (response.data.status == 'success') {
                        const dataRespon = response.data.data
                        const trDate = new Date(dataRespon.date);
                        console.log(trDate);
                        document.getElementById('transactionDate').value = trDate.toLocaleDateString('en-CA');
                        document.getElementById('editAmount').value = dataRespon.amount;

                        // Ambil category dari api
                        axios.get('../api/category/get.php')
                            .then(response => {
                                const categories = response.data.data;
                                const categorySelect = document.getElementById('editCategory');

                                categories.forEach(category => {
                                    const option = document.createElement('option');
                                    option.value = category.id;
                                    option.textContent = category.name;
                                    categorySelect.appendChild(option);
                                });

                                document.getElementById('editCategory').value = dataRespon.categoryid;
                            })
                            .catch(error => {
                                console.error('Error fetching categories:', error);
                            });
                        document.getElementById('editStatus').value = dataRespon.statusTransaksi;
                        $('#editTransactionModal').modal('show');
                    } else {
                        alert('Feteching history data failed. Please try again.' + response.data.message)
                    }
                })
                .catch(error => {
                    console.error('Error fetching transaction data:', error);
                });
        }

        document.getElementById('editTransactionForm').addEventListener('submit', function (e) {
            e.preventDefault();
            const sessionToken = localStorage.getItem('session_token');

            const formData = new FormData();
            formData.append('session_token', sessionToken)
            formData.append('date', document.getElementById('transactionDate').value);
            formData.append('amount', document.getElementById('editAmount').value);
            formData.append('statustransaction', document.getElementById('editStatus').value);
            formData.append('idcategory', document.getElementById('editCategory').value)
            formData.append('transaction_id', currentTransactionId)

            axios.post('../api/transaction/update.php', formData)
            .then(response => {
                console.log(response.data)
                if (response.data.status === 'success') {
                    $('#editTransactionModal').modal('hide');
                    loadTransactionHistory();
                } else {
                    alert('Gagal edit transaksi' + response.data.message);
                    return;
                }
            })
            .catch(error => {
                console.error('Error editing transaction:', error);
            });
        });

        function confirmDeleteTransaction(id) {
            currentTransactionId = id;
            $('#deleteConfirmationModal').modal('show');
        }

        document.getElementById('confirmDeleteButton').addEventListener('click', function () {
            const formData = new FormData();
            formData.append('transaction_id', currentTransactionId)
            formData.append('session_token', localStorage.getItem('session_token'));

            axios.post('../api/transaction/delete.php', formData)
                .then(response => {
                    if (response.data.status === 'success') {
                        $('#deleteConfirmationModal').modal('hide');
                    loadTransactionHistory(); 
                    } else {
                        alert('Gagal delete transaksi. ' + response.data.message);
                        return;
                    }
                })
                .catch(error => {
                    console.error('Error deleting transaction:', error);
                });
        });

        
        $(document).ready(function () {
            $('#transactionDate').datepicker({
                format: 'yyyy-mm-dd',
                endDate: 'today',
                autoclose: true
            });

            loadTransactionHistory();
        });
    </script>
</body>
<?php include 'footer.php'; ?>
</html>
