<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - CuanBijak</title>
    <link href="../bootstrap-5.3.3-dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-datepicker@1.9.0/dist/css/bootstrap-datepicker.min.css" rel="stylesheet">
    <style>
        body {
            padding-top: 60px; /* Sesuaikan dengan tinggi navbar */
            background-color: #f8f9fa; /* Warna latar belakang yang lebih lembut */
        }
        /* Navbar Styling */
        .navbar-custom {
            background-color:rgb(56, 56, 56) !important; /* Warna abu-abu gelap */
            box-shadow: 0px 4px 6px rgba(150, 8, 8, 0.1);
            padding: 12px 0;
        }

        .navbar-nav .nav-link:hover {
            color:rgb(179, 86, 90) !important;
        }

        .navbar-nav .nav-link {
            color: #fff !important;
            font-weight: 500;
            transition: color 0.3s;
        }      

        @media (max-width: 768px) {
        .container {
            padding: 10px;
        }
        .card {
            padding: 15px;
        }
    }
    </style>
</head>

<body>
    <nav class="navbar navbar-expand-lg navbar-dark navbar-custom fixed-top">
        <div class="container">
            <a class="navbar-brand" href="#">
                <img src="../image/cuan.png" alt="CuanBijak Logo" width="50">
            </a>
            <a class="navbar-brand" href="#">CuanBijak</a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item"><a class="nav-link" href="dashboard.php">Beranda</a></li>
                    <li class="nav-item"><a class="nav-link" href="transaction.php">Transaksi</a></li>
                    <li class="nav-item"><a class="nav-link" href="history.php">Riwayat</a></li>
                    
                    <!-- Tambahkan Dropdown Akun -->
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            Akun
                        </a>
                        <ul class="dropdown-menu" aria-labelledby="navbarDropdown">
                            <li><a class="dropdown-item" href="profile.php">Profil</a></li>
                            <li><a class="dropdown-item" href="#" onclick="logout()">Logout</a></li>
                        </ul>
                    </li>
                </ul>
        </div>
    </nav>
    <div class="container my-5">
        <div class="row">
            <div class="col-md-6 offset-md-3">
                <div class="card shadow-lg border-0 rounded-4">
                    <div class="card-header text-white" style="background: linear-gradient(45deg,rgb(226, 74, 74),rgb(134, 5, 5));">
                        <h5>Tambah Transaksi</h5>
                    </div>
                    <div class="card-body">
                        <form id="transactionForm">
                            <div class="mb-3">
                                <label for="transactionDate" class="form-label">Tanggal Transaksi</label>
                                <input type="text" class="form-control" id="transactionDate" placeholder="Pilih Tanggal" required>
                            </div>
                            <div class="mb-3">
                                <label for="amount" class="form-label">Jumlah</label>
                                <input type="number" class="form-control" id="amount" placeholder="Masukkan Jumlah" required>
                            </div>
                            <div class="mb-3">
                                <label for="type" class="form-label">Tipe Transaksi</label>
                                <select class="form-select" id="type" required>
                                    <option value="0">Pengeluaran</option>
                                    <option value="1">Pemasukan</option>
                                </select>
                            </div>
                            <div class="mb-3">
                                <label for="category" class="form-label">Kategori</label>
                                <select class="form-select" id="category" required>
                                    <option value="" selected>Pilih Kategori</option>
                                </select>
                            </div>

                            <style>
                                .btn-custom {
                                    background-color:rgb(134, 5, 5); /* Warna Oranye */
                                    color: white;
                                    border: none;
                                }

                                .btn-custom:hover {
                                    background-color:rgb(226, 74, 74); /* Warna lebih gelap saat hover */
                                }
                            </style>

                            <button type="submit" class="btn btn-custom w-100 fw-bold py-2 shadow-sm" style="transition: 0.3s;">
                                Simpan
                            </button>                            
                        </form>
                    </div>
                </div>
            </div>
        </div>

    </div>

    <script src="../bootstrap-5.3.3-dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap-datepicker@1.9.0/dist/js/bootstrap-datepicker.min.js"></script>

    <script>
        function logout() {
            const sessionToken = localStorage.getItem('session_token');

            const formData = new FormData();
            formData.append('session_token', sessionToken);

            axios.post('../api/logout.php', formData)
                .then(response => {
                    if (response.data.status == 'success') {
                        localStorage.removeItem('session_token');
                        window.location.href = 'login.php'
                    } else {
                        alert('logout failed. ' + response.data.message)
                    }
                })
                .catch(error => {
                    console.error('Error during logout:', error)
                });
        }

        function checkSession() {
            const formData = new FormData
            formData.append('session_token', localStorage.getItem('session_token'));

            axios.post('../api/session.php', formData)
                .then(response => {
                    console.log(response);
                    if (response.data.status !== 'success') {
                        window.location.href = 'login.php'
                    }
                })
                .catch(error => {
                    console.error('Error checking session:', error);
                });
        }

        checkSession();

        $(document).ready(function () {
            $('#transactionDate').datepicker({
                format: 'yyyy-mm-dd',
                endDate: 'today',
                autoclose: true
            });

            // Mengatur tanggal hari ini
            const today = new Date();
            const todayFormatted = today.toISOString().split('T')[0]; 
            $('#transactionDate').val(todayFormatted);  // Isi input dengan tanggal hari ini

            // Ambil category dari api
            axios.get('../api/category/get.php')
                .then(response => {
                    const categories = response.data.data;
                    const categorySelect = document.getElementById('category');

                    categories.forEach(category => {
                        const option = document.createElement('option');
                        option.value = category.id;
                        option.textContent = category.name;
                        categorySelect.appendChild(option);
                    });
                })
                .catch(error => {
                    console.error('Error fetching categories:', error);
                });
        });

        // Proses tambah transaksi ke api
        document.getElementById('transactionForm').addEventListener('submit', function(event) {
            event.preventDefault();
            const date = document.getElementById('transactionDate').value;
            const amount = document.getElementById('amount').value;
            const type = document.getElementById('type').value;
            const category = document.getElementById('category').value;

            const sessionToken = localStorage.getItem('session_token');

            const formData = new FormData();
            formData.append('session_token', sessionToken)
            formData.append('date', date);
            formData.append('amount', amount);
            formData.append('statustransaction', type);
            formData.append('idcategory', category)

            axios.post('../api/transaction/add.php', formData)
            .then(response => {
                console.log(response.data)
                if (response.data.status === 'success') {
                    alert('Transaksi berhasil ditambahkan.');
                } else {
                    alert('Gagal menambahkan transaksi' + response.data.message);
                }
            })
            .catch(error => {
                console.error('Error adding transaction:', error);
            });
        });
    </script>
</body>
<?php include 'footer.php'; ?>

</html>